using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using PolCommon;
using System.Text;
using System.IO;
using System.Runtime.Serialization.Formatters.Soap;

namespace PolServer
{
	/// <summary>
	/// Range and location setting.
	/// <p>Copyright (c) 2002 Alexis Grandemange<br/>
	/// Mail: alexis.grandemange@pagebox.net</p>
	/// <pre>This program is free software; you can redistribute it and/or
	/// modify it under the terms of the GNU Lesser General Public
	/// License as published by the Free Software Foundation; version
	/// 2.1 of the License.
	/// This library is distributed in the hope that it will be useful,
	/// but WITHOUT ANY WARRANTY; without even the implied warranty of
	/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	/// GNU Lesser General Public License for more details.
	/// A copy of the GNU Lesser General Public License lesser.txt should be
	/// included in the distribution.</pre>
	/// </summary>
	public class RangeLoc : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.TextBox UserLow;
		protected System.Web.UI.WebControls.TextBox UserHigh;
		protected System.Web.UI.WebControls.Button ButSet;
		protected System.Web.UI.WebControls.TextBox Location;
		protected System.Web.UI.WebControls.Label lblStatus;
	
		/// <summary>
		/// ActiveNaming proxy
		/// </summary>
		ActiveNaming an = null;

		public RangeLoc()
		{
			Page.Init += new System.EventHandler(Page_Init);
		}

		/// <summary>
		/// Calls ActiveNaming.GetKeyRange
		/// </summary>
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack) 
			{
				if (an == null)
					an = GetProxy();
				if (an != null) 
				{
					try 
					{
						string kr = an.GetKeyRange("PolServer.zip", "ShoppingOrder");
						if ((kr != null) && (kr.Length > 0)) 
						{
							PolarisKR pskr = deserializePKR(kr);
							UserLow.Text = pskr.userLow.ToString();
							UserHigh.Text = pskr.userHigh.ToString();
							Location.Text = pskr.location;
						}
					}
					catch(Exception ex) 
					{
						lblStatus.Text = "Exception in Page_Load: " + ex.Message;
					}
				}
			}
		}

		private void Page_Init(object sender, EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
		}

		#region Web Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ButSet.Click += new System.EventHandler(this.OnSet);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		/// <summary>
		/// Called when the user clicks on the Set button.
		/// Calls ActiveNaming.SetKeyRange
		/// </summary>
		private void OnSet(object sender, System.EventArgs e)
		{
			if (an == null)
				an = GetProxy();
			if (an != null) 
			{
				try 
				{
					PolarisKR pkr = new PolarisKR();
					pkr.userLow = Int32.Parse(UserLow.Text);
					pkr.userHigh = Int32.Parse(UserHigh.Text);
					pkr.location = Location.Text;
					an.SetKeyRange("PolServer.zip", "ShoppingOrder", serializePKR(pkr));
					lblStatus.Text = "";
				}
				catch(Exception ex) 
				{
					lblStatus.Text = "Exception in OnSet: " + ex.Message + " " + an.Url;
				}
			}
		}

		/// <summary>
		/// Create an ActiveNaming proxy.
		/// To retrieve the control PageBox,
		/// assumes that PolServer is installed in the PageBox directory
		/// </summary>
		/// <returns>Checked Active Naming proxy</returns>
		private ActiveNaming GetProxy() 
		{
			string lpath = Request.ServerVariables["PATH_INFO"];
			string host = Request.ServerVariables["HTTP_HOST"];
			string port = Request.ServerVariables["SERVER_PORT"];
			int pos = lpath.LastIndexOf("/");
			lpath = lpath.Substring(0, pos);
			pos = lpath.LastIndexOf("/");
			lpath = lpath.Substring(0, pos + 1) + "ActiveNaming.asmx";
			string url;
			if (port.Equals("80"))
				url = "http://" + host + lpath;
			else
				url = "http://" + host + ":" + port + lpath;
			// url = "http://localhost/PageBox/PageBox/ActiveNaming.asmx";
			ActiveNaming a = new ActiveNaming(url);
			try 
			{
				a.Discover();
				return a;
			}
			catch(Exception e) 
			{
				lblStatus.Text = "Exception in GetProxy: " + e.Message + " for " + url;
			}
			return null;
		}

		/// <summary>
		/// Deserialize PolarisKR from ActiveNaming KeyRange
		/// </summary>
		/// <param name="keyRange">Serialized key range</param>
		/// <returns>Deserialized PolarisKR</returns>
		PolarisKR deserializePKR(string keyRange) 
		{
			SoapFormatter sf = new SoapFormatter();
			ASCIIEncoding ae = new ASCIIEncoding();
			MemoryStream ms = new MemoryStream(ae.GetBytes(keyRange));
			return (PolarisKR)sf.Deserialize(ms);
		}

		/// <summary>
		/// Serialize PolarisKR to string
		/// </summary>
		/// <param name="al">PolarisKR object</param>
		/// <returns>Serialized key range</returns>
		string serializePKR(PolarisKR pkr) 
		{
			ASCIIEncoding ae = new ASCIIEncoding();
			SoapFormatter sf = new SoapFormatter();
			MemoryStream ms = new MemoryStream();
			sf.Serialize(ms, pkr);
			return ae.GetString(ms.GetBuffer());
		}
	}
}
