using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;

namespace PolServer
{
	/// <summary>
	/// Polaris Web service.
	/// Called by peer Reservation instances.
	/// <p>Copyright (c) 2002 Alexis Grandemange<br/>
	/// Mail: alexis.grandemange@pagebox.net</p>
	/// <pre>This program is free software; you can redistribute it and/or
	/// modify it under the terms of the GNU Lesser General Public
	/// License as published by the Free Software Foundation; version
	/// 2.1 of the License.
	/// This library is distributed in the hope that it will be useful,
	/// but WITHOUT ANY WARRANTY; without even the implied warranty of
	/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	/// GNU Lesser General Public License for more details.
	/// A copy of the GNU Lesser General Public License lesser.txt should be
	/// included in the distribution.</pre>
	/// </summary>
	[WebService(Namespace="Polaris")]
	public class ShoppingOrder : System.Web.Services.WebService
	{
		public ShoppingOrder()
		{
			//CODEGEN: This call is required by the ASP.NET Web Services Designer
			InitializeComponent();
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}
		#endregion

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
		}

		/// <summary>
		/// Fake implementation: returns false if the customer account starts with mal (Mallory)
		/// </summary>
		/// <param name="accountID">Customer account</param>
		/// <returns>True in case of success</returns>
		[WebMethod]
		public bool CheckAccount(string accountID)
		{
			if (accountID.StartsWith("mal"))
				return false;
			else
				return true;
		}

		/// <summary>
		/// Fake implementation: returns false if the customer account starts with bob (Bob)
		/// </summary>
		/// <param name="accountID">Customer account</param>
		/// <param name="orders">command lines</param>
		/// <returns>True in case of success</returns>
		[WebMethod]
		public bool Order(string accountID, OrderRow[] lines)
		{
			return true;
		}
	}

	/// <summary>
	/// Describes a command line
	/// </summary>
	public class OrderRow 
	{
		/// <summary>
		/// Article name
		/// </summary>
		public string article;
		/// <summary>
		/// Price of an article
		/// </summary>
		public int price;
		/// <summary>
		/// Number of articles
		/// </summary>
		public int qty;
	}
}
